#ifndef NASCCL_NASCCL_H
#define NASCCL_NASCCL_H
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define NASCCLByte unsigned char

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define ROUNDMUTATION      0x0001
#define SWAPMATRIX         0x0002
#define ROUNDRESULT        0x0004
#define NONREPETITION      0x0010
#define ENSUREOFFSET       0x0020
#define FMATRIXMUTATION    0x0040
#define RMATRIXMUTATION    0x0080
#define CMATRIXMUTATION    0x0100
#define CRYPTFULLDATASET   0x0200
#define RUNNINGKEYPOSITION 0x0400
#define CIPHERUSERSKEY     0x0800

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class NASCCL{
    public:
        //-------------(Functions)
        bool Decode(void *DataIn, void *DataOut, int DataSize);
        bool Encode(void *DataIn, void *DataOut, int DataSize);
        bool InitializeCryptographySet(void *Key, int SizeOfKey, int Attribute);
        bool UninitializeCryptographySet(void);

    private:
        //-------------(Variables)
        int Attribute;
        int KeyHashPos;
        int KeyHashLen;

        NASCCLByte *KeyHash;

        NASCCLByte Matrix[6][6]; // (288-Bit Matrix) ((6 * 6) * 8)
        NASCCLByte MValue[6][6]; // (288-Bit Matrix) ((6 * 6) * 8)

        //-------------(Functions)
        void MatrixMutate(NASCCLByte MValue);
        void SwapMatrix(int Swap, int With);
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CipherKey(void *InputKey, void *OutputKey, int SizeOfKey);
bool HashKey(void *InputKey, void *OutputKey, int SizeOfKey, int FinalSize);

char *GetAlgorithmName(void);
char *GetAlgorithmVersion(void);

int GetMaxBitStrength(void);
int GetMaxKeyLength(void);
int GetMinBitStrength(void);
int GetMinKeyLength(void);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

